# scatter plot of line-circle model
library(plot3D)
library(RColorBrewer)
library(MASS)
set.seed(123)

source("signals.R")

col_pal <- brewer.pal(n = 8, name = "Dark2")
n <- 3000
delta <- 3 
sig <- 1
K <- 2
# set noise_sig = 0 to get noiseless version
noise_sig <- 0.1

dat <- line_circle(n, delta = delta,
                 line_sig = sig, noise_sig = noise_sig,
                 pri=c(1,1)/2)
x <- dat[ , 1:3]
labels <- as.numeric(dat$label)
scatter3D(x[,1], x[,2], x[,3], col=col_pal[1:2], colvar = labels,
          pch=19, cex=0.5, theta=65, colkey = F)

k <- 4
res <- kmeans(x,k)
colors <- col_pal[as.numeric(res$cluster)]
# pdf(file = "line_circle_noise_delta=3_n=3000.pdf")
# width =  9.99, height = 8.16)
scatter3D(x[,1], x[,2], x[,3], col=col_pal[1:4], colvar = res$cluster,
          pch=19, cex=0.5, theta=65, colkey = F)
#dev.off()
